<?php

/*---------------------------------------------
  MAIAN MAIL v3.1
  Written by David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: www.maianscriptworld.co.uk
  This File: Box Trapper Class
  Added in v3.1
----------------------------------------------*/

class boxTrapper {
  
                  var $whitelist;
                  var $duration;
                  var $code;

                  //===================================================
                  // Function: checkEmailAddress
                  // Param: 1
                  // Desc: Check e-mail address against whitelist
                  //===================================================

                  function checkEmailAddress($email)
                  {
                    if (file_exists('boxtrapper/'.$this->whitelist))
                    {
                      $file = file('boxtrapper/'.$this->whitelist);
                      
                      if (!empty($file))
                      {
                        for($i=0; $i<count($file); $i++)
                        {
                          $em = trim($file[$i]);

                          if ($email==$this->convertEmailAddress($em,true))
                          {
                            $search = true;
                          }
                        }

                        if (isset($search))
                        {
                          return true;
                        }
                        else
                        {
                          return false;
                        }
                      }
                      else
                      {
                        return false;
                      }
                    }
                    else
                    {
                      return false;
                    }
                  }

                  //==============================================================
                  // Function: convertEmailAddress
                  // Param: 2
                  // Desc: Parse e-mail address and convert @ and period symbols
                  //==============================================================

                  function convertEmailAddress($email,$back=false)
                  {
                    $find     = array((!$back ? "@" : "[at]"),(!$back ? "." : "[dot]"));
                    $replace  = array((!$back ? "[at]" : "@"),(!$back ? "[dot]" : "."));

                    return str_replace($find,$replace,$email);
                  }

                  //===================================================
                  // Function: autoCronBoxTrapper
                  // Param: 0
                  // Desc: Auto run when someone accesses form
                  //===================================================

                  function autoCronBoxTrapper()
                  {
                    $date = date("Y-m-d", strtotime("-".$this->duration." days"));

                    $dir = opendir('boxtrapper/');

                    while ($read = readdir($dir))
                    {
                      if ($read!='index.html' && $read!='.' && $read!='..' && $read!=$this->whitelist)
                      {
                        $name = explode("_", $read);

                        if ($name[0]<$date)
                        {
                          @unlink('boxtrapper/'.$read);
                        }
                      }
                    }

                    closedir($dir);
                  }

                  //===================================================
                  // Function: writeToWhiteList
                  // Param: 1
                  // Desc: Add e-mail to whitelist
                  //===================================================

                  function writeToWhiteList($email)
                  {
                    if (file_exists('boxtrapper/'.$this->whitelist))
                    {
                      $data = file_get_contents('boxtrapper/'.$this->whitelist);
                    }
                    if (isset($data))
                    {
                      @unlink('boxtrapper/'.$this->whitelist);
                    }  
                      
                    $fp = fopen('boxtrapper/'.$this->whitelist, 'ab');

                    if ($fp)
                    {
                      fwrite($fp,(isset($data) ? trim($data).$this->defineNewline() : '').$this->convertEmailAddress($email));
                      fclose($fp);
                    }
                  }

                  //===================================================
                  // Function: getBoxTrapperData
                  // Param: 3
                  // Desc: Get data from box trapper directory
                  //===================================================

                  function getBoxTrapperData($code,$data=false,$name=false)
                  {
                    $dir = opendir('boxtrapper/');

                    while ($read = readdir($dir))
                    {
                      if ($read!='index.html' && $read!='.' && $read!='..' && $read!=$this->whitelist)
                      {
                        $info = explode("_", $read);

                        if (substr($info[1],0,10)==$code)
                        {
                          $match = $read;
                        }
                      }
                    }

                    closedir($dir);

                    if (isset($match))
                    {
                      return ($data ? ($name ? $match : file_get_contents('boxtrapper/'.$match)) : true);
                    }
                    else
                    {
                      return false;
                    }
                  }
                  
                  //===================================================
                  // Function: deleteBoxTrapperData
                  // Param: 1
                  // Desc: Deletes box trapper data
                  //===================================================

                  function deleteBoxTrapperData($file)
                  {
                    if (file_exists('boxtrapper/'.$file))
                    {
                      @unlink('boxtrapper/'.$file);
                    }
                  }

                  //===================================================
                  // Function: writeToDataFile
                  // Param: 4
                  // Desc: Write data to data file
                  //===================================================

                  function writeToDataFile($name,$email,$subject,$comments)
                  {
                    $file    = date("Y-m-d").'_'.$this->code.'.txt';
                    $string  = $name.$this->addSeperator().$email.$this->addSeperator().$subject.$this->addSeperator().$comments;

                    $fp = fopen('boxtrapper/'.$file, 'ab');

                    if ($fp)
                    {
                      fwrite($fp,trim($string));
                      fclose($fp);
                    }
                  }

                  //===================================================
                  // Function: addSeperator
                  // Param: 0
                  // Desc: Seperator for data
                  //===================================================

                  function addSeperator()
                  {
                    return "###";
                  }

                  //===================================================
                  // Function: randomCodeGenerator
                  // Param: 0
                  // Desc: Generates random string
                  //===================================================

                  function randomCodeGenerator($num)
                  {
                    $p = substr(md5(uniqid(rand(),1)),3,$num);

                    return $p;
                  }
                  
                  //===================================================
                  // Function: defineNewline
                  // Param: 0
                  // Desc: New line char
                  //===================================================

                  function defineNewline()
                  {
                    $nl = "\r\n";

                    if (strstr(strtolower($_SERVER["HTTP_USER_AGENT"]), 'win'))
                    {
                      $nl = "\r\n";
                    }
                    else if (strstr(strtolower($_SERVER["HTTP_USER_AGENT"]), 'mac'))
                    {
                      $nl = "\r";
                    }
                    else
                    {
                      $nl = "\n";
                    }

                    return $nl;
                  }
}

?>